/*
 * Decompiled with CFR 0.152.
 */
package jace.tracker;

import jace.apple2e.MOS65C02;
import jace.core.Card;
import jace.core.Computer;
import jace.core.Motherboard;
import jace.hardware.CardExt80Col;
import jace.hardware.CardMockingboard;

public class PlaybackEngine
extends Computer {
    Motherboard motherboard = new Motherboard();
    CardMockingboard mockingboard = new CardMockingboard();

    public PlaybackEngine() {
        this.setMemory(new CardExt80Col());
        this.setCpu(new MOS65C02());
        this.getMemory().addCard(this.mockingboard, 5);
    }

    @Override
    public void coldStart() {
        for (Card c : this.getMemory().getAllCards()) {
            if (c == null) continue;
            c.reset();
        }
    }

    @Override
    public void warmStart() {
        for (Card c : this.getMemory().getAllCards()) {
            if (c == null) continue;
            c.reset();
        }
    }

    @Override
    protected boolean isRunning() {
        return this.motherboard.isRunning();
    }

    @Override
    protected void doPause() {
        this.motherboard.suspend();
    }

    @Override
    protected void doResume() {
        this.motherboard.resume();
    }

    @Override
    public String getName() {
        return "Playback Computer";
    }

    @Override
    public String getShortName() {
        return "Computer";
    }

    @Override
    public void reconfigure() {
    }
}

